<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class UsersListResponse extends \Google\Collection
{
  protected $collection_key = 'items';
  protected $itemsType = User::class;
  protected $itemsDataType = 'array';
  /**
   * This is always `sql#usersList`.
   *
   * @var string
   */
  public $kind;
  /**
   * Unused.
   *
   * @deprecated
   * @var string
   */
  public $nextPageToken;

  /**
   * List of user resources in the instance.
   *
   * @param User[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return User[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * This is always `sql#usersList`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Unused.
   *
   * @deprecated
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UsersListResponse::class, 'Google_Service_SQLAdmin_UsersListResponse');
