<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MigrationCenterAPI\Resource;

use Google\Service\MigrationCenterAPI\GenerateReportArtifactLinkRequest;
use Google\Service\MigrationCenterAPI\ListReportsResponse;
use Google\Service\MigrationCenterAPI\Operation;
use Google\Service\MigrationCenterAPI\Report;
use Google\Service\MigrationCenterAPI\ReportArtifactLink;

/**
 * The "reports" collection of methods.
 * Typical usage is:
 *  <code>
 *   $migrationcenterService = new Google\Service\MigrationCenterAPI(...);
 *   $reports = $migrationcenterService->projects_locations_reportConfigs_reports;
 *  </code>
 */
class ProjectsLocationsReportConfigsReports extends \Google\Service\Resource
{
  /**
   * Gets the link to the generated artifact of a given type for a Report.
   * (reports.artifactLink)
   *
   * @param string $name Required. Name of the resource.
   * @param GenerateReportArtifactLinkRequest $postBody
   * @param array $optParams Optional parameters.
   * @return ReportArtifactLink
   * @throws \Google\Service\Exception
   */
  public function artifactLink($name, GenerateReportArtifactLinkRequest $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('artifactLink', [$params], ReportArtifactLink::class);
  }
  /**
   * Creates a report. (reports.create)
   *
   * @param string $parent Required. Value for parent.
   * @param Report $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string reportId Required. User specified id for the report. It
   * will become the last component of the report name. The id must be unique
   * within the project, must conform with RFC-1034, is restricted to lower-cased
   * letters, and has a maximum length of 63 characters. The id must match the
   * regular expression: [a-z]([a-z0-9-]{0,61}[a-z0-9])?.
   * @opt_param string requestId Optional. An optional request ID to identify
   * requests. Specify a unique request ID so that if you must retry your request,
   * the server will know to ignore the request if it has already been completed.
   * The server will guarantee that for at least 60 minutes since the first
   * request. For example, consider a situation where you make an initial request
   * and the request times out. If you make the request again with the same
   * request ID, the server can check if original operation with the same request
   * ID was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments. The request ID must
   * be a valid UUID with the exception that zero UUID is not supported
   * (00000000-0000-0000-0000-000000000000).
   * @return Operation
   * @throws \Google\Service\Exception
   */
  public function create($parent, Report $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], Operation::class);
  }
  /**
   * Deletes a Report. (reports.delete)
   *
   * @param string $name Required. Name of the resource.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string requestId Optional. An optional request ID to identify
   * requests. Specify a unique request ID so that if you must retry your request,
   * the server will know to ignore the request if it has already been completed.
   * The server will guarantee that for at least 60 minutes after the first
   * request. For example, consider a situation where you make an initial request
   * and the request times out. If you make the request again with the same
   * request ID, the server can check if original operation with the same request
   * ID was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments. The request ID must
   * be a valid UUID with the exception that zero UUID is not supported
   * (00000000-0000-0000-0000-000000000000).
   * @return Operation
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], Operation::class);
  }
  /**
   * Gets details of a single Report. (reports.get)
   *
   * @param string $name Required. Name of the resource.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string view Determines what information to retrieve for the
   * Report.
   * @return Report
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], Report::class);
  }
  /**
   * Lists Reports in a given ReportConfig.
   * (reports.listProjectsLocationsReportConfigsReports)
   *
   * @param string $parent Required. Parent value for `ListReportsRequest`.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string filter Filtering results.
   * @opt_param string orderBy Field to sort by. See
   * https://google.aip.dev/132#ordering for more details.
   * @opt_param int pageSize Requested page size. The server may return fewer
   * items than requested. If unspecified, the server will pick an appropriate
   * default value.
   * @opt_param string pageToken A token identifying a page of results that the
   * server should return.
   * @opt_param string view Determines what information to retrieve for each
   * Report.
   * @return ListReportsResponse
   * @throws \Google\Service\Exception
   */
  public function listProjectsLocationsReportConfigsReports($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], ListReportsResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsReportConfigsReports::class, 'Google_Service_MigrationCenterAPI_Resource_ProjectsLocationsReportConfigsReports');
