<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class ListPropertiesSuggestionState extends \Google\Collection
{
  protected $collection_key = 'nestingLevelsSuggestionStates';
  protected $nestingLevelsSuggestionStatesType = NestingLevelSuggestionState::class;
  protected $nestingLevelsSuggestionStatesDataType = 'array';

  /**
   * A mask that indicates which of the fields on the corresponding NestingLevel
   * in nesting_levels have been changed in this suggestion. The nesting level
   * suggestion states are returned in ascending order of the nesting level with
   * the least nested returned first.
   *
   * @param NestingLevelSuggestionState[] $nestingLevelsSuggestionStates
   */
  public function setNestingLevelsSuggestionStates($nestingLevelsSuggestionStates)
  {
    $this->nestingLevelsSuggestionStates = $nestingLevelsSuggestionStates;
  }
  /**
   * @return NestingLevelSuggestionState[]
   */
  public function getNestingLevelsSuggestionStates()
  {
    return $this->nestingLevelsSuggestionStates;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListPropertiesSuggestionState::class, 'Google_Service_Docs_ListPropertiesSuggestionState');
