<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datastore;

class Entity extends \Google\Model
{
  protected $keyType = Key::class;
  protected $keyDataType = '';
  protected $propertiesType = Value::class;
  protected $propertiesDataType = 'map';

  /**
   * The entity's key. An entity must have a key, unless otherwise documented
   * (for example, an entity in `Value.entity_value` may have no key). An
   * entity's kind is its key path's last element's kind, or null if it has no
   * key.
   *
   * @param Key $key
   */
  public function setKey(Key $key)
  {
    $this->key = $key;
  }
  /**
   * @return Key
   */
  public function getKey()
  {
    return $this->key;
  }
  /**
   * The entity's properties. The map's keys are property names. A property name
   * matching regex `__.*__` is reserved. A reserved property name is forbidden
   * in certain documented contexts. The map keys, represented as UTF-8, must
   * not exceed 1,500 bytes and cannot be empty.
   *
   * @param Value[] $properties
   */
  public function setProperties($properties)
  {
    $this->properties = $properties;
  }
  /**
   * @return Value[]
   */
  public function getProperties()
  {
    return $this->properties;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Entity::class, 'Google_Service_Datastore_Entity');
