<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2BoundingBox extends \Google\Model
{
  /**
   * Height of the bounding box in pixels.
   *
   * @var int
   */
  public $height;
  /**
   * Left coordinate of the bounding box. (0,0) is upper left.
   *
   * @var int
   */
  public $left;
  /**
   * Top coordinate of the bounding box. (0,0) is upper left.
   *
   * @var int
   */
  public $top;
  /**
   * Width of the bounding box in pixels.
   *
   * @var int
   */
  public $width;

  /**
   * Height of the bounding box in pixels.
   *
   * @param int $height
   */
  public function setHeight($height)
  {
    $this->height = $height;
  }
  /**
   * @return int
   */
  public function getHeight()
  {
    return $this->height;
  }
  /**
   * Left coordinate of the bounding box. (0,0) is upper left.
   *
   * @param int $left
   */
  public function setLeft($left)
  {
    $this->left = $left;
  }
  /**
   * @return int
   */
  public function getLeft()
  {
    return $this->left;
  }
  /**
   * Top coordinate of the bounding box. (0,0) is upper left.
   *
   * @param int $top
   */
  public function setTop($top)
  {
    $this->top = $top;
  }
  /**
   * @return int
   */
  public function getTop()
  {
    return $this->top;
  }
  /**
   * Width of the bounding box in pixels.
   *
   * @param int $width
   */
  public function setWidth($width)
  {
    $this->width = $width;
  }
  /**
   * @return int
   */
  public function getWidth()
  {
    return $this->width;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2BoundingBox::class, 'Google_Service_DLP_GooglePrivacyDlpV2BoundingBox');
