<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class ResizeVolumeRequest extends \Google\Model
{
  /**
   * New Volume size, in GiB.
   *
   * @var string
   */
  public $sizeGib;

  /**
   * New Volume size, in GiB.
   *
   * @param string $sizeGib
   */
  public function setSizeGib($sizeGib)
  {
    $this->sizeGib = $sizeGib;
  }
  /**
   * @return string
   */
  public function getSizeGib()
  {
    return $this->sizeGib;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResizeVolumeRequest::class, 'Google_Service_Baremetalsolution_ResizeVolumeRequest');
