<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Appengine;

class AuthorizedCertificate extends \Google\Collection
{
  protected $collection_key = 'visibleDomainMappings';
  protected $certificateRawDataType = CertificateRawData::class;
  protected $certificateRawDataDataType = '';
  /**
   * The user-specified display name of the certificate. This is not guaranteed
   * to be unique. Example: My Certificate.
   *
   * @var string
   */
  public $displayName;
  /**
   * Aggregate count of the domain mappings with this certificate mapped. This
   * count includes domain mappings on applications for which the user does not
   * have VIEWER permissions.Only returned by GET or LIST requests when
   * specifically requested by the view=FULL_CERTIFICATE option.@OutputOnly
   *
   * @var int
   */
  public $domainMappingsCount;
  /**
   * Output only. Topmost applicable domains of this certificate. This
   * certificate applies to these domains and their subdomains. Example:
   * example.com.@OutputOnly
   *
   * @var string[]
   */
  public $domainNames;
  /**
   * The time when this certificate expires. To update the renewal time on this
   * certificate, upload an SSL certificate with a different expiration time
   * using AuthorizedCertificates.UpdateAuthorizedCertificate.@OutputOnly
   *
   * @var string
   */
  public $expireTime;
  /**
   * Output only. Relative name of the certificate. This is a unique value
   * autogenerated on AuthorizedCertificate resource creation. Example:
   * 12345.@OutputOnly
   *
   * @var string
   */
  public $id;
  protected $managedCertificateType = ManagedCertificate::class;
  protected $managedCertificateDataType = '';
  /**
   * Output only. Full path to the AuthorizedCertificate resource in the API.
   * Example: apps/myapp/authorizedCertificates/12345.@OutputOnly
   *
   * @var string
   */
  public $name;
  /**
   * Output only. The full paths to user visible Domain Mapping resources that
   * have this certificate mapped. Example:
   * apps/myapp/domainMappings/example.com.This may not represent the full list
   * of mapped domain mappings if the user does not have VIEWER permissions on
   * all of the applications that have this certificate mapped. See
   * domain_mappings_count for a complete count.Only returned by GET or LIST
   * requests when specifically requested by the view=FULL_CERTIFICATE
   * option.@OutputOnly
   *
   * @var string[]
   */
  public $visibleDomainMappings;

  /**
   * The SSL certificate serving the AuthorizedCertificate resource. This must
   * be obtained independently from a certificate authority.
   *
   * @param CertificateRawData $certificateRawData
   */
  public function setCertificateRawData(CertificateRawData $certificateRawData)
  {
    $this->certificateRawData = $certificateRawData;
  }
  /**
   * @return CertificateRawData
   */
  public function getCertificateRawData()
  {
    return $this->certificateRawData;
  }
  /**
   * The user-specified display name of the certificate. This is not guaranteed
   * to be unique. Example: My Certificate.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Aggregate count of the domain mappings with this certificate mapped. This
   * count includes domain mappings on applications for which the user does not
   * have VIEWER permissions.Only returned by GET or LIST requests when
   * specifically requested by the view=FULL_CERTIFICATE option.@OutputOnly
   *
   * @param int $domainMappingsCount
   */
  public function setDomainMappingsCount($domainMappingsCount)
  {
    $this->domainMappingsCount = $domainMappingsCount;
  }
  /**
   * @return int
   */
  public function getDomainMappingsCount()
  {
    return $this->domainMappingsCount;
  }
  /**
   * Output only. Topmost applicable domains of this certificate. This
   * certificate applies to these domains and their subdomains. Example:
   * example.com.@OutputOnly
   *
   * @param string[] $domainNames
   */
  public function setDomainNames($domainNames)
  {
    $this->domainNames = $domainNames;
  }
  /**
   * @return string[]
   */
  public function getDomainNames()
  {
    return $this->domainNames;
  }
  /**
   * The time when this certificate expires. To update the renewal time on this
   * certificate, upload an SSL certificate with a different expiration time
   * using AuthorizedCertificates.UpdateAuthorizedCertificate.@OutputOnly
   *
   * @param string $expireTime
   */
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  /**
   * @return string
   */
  public function getExpireTime()
  {
    return $this->expireTime;
  }
  /**
   * Output only. Relative name of the certificate. This is a unique value
   * autogenerated on AuthorizedCertificate resource creation. Example:
   * 12345.@OutputOnly
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Only applicable if this certificate is managed by App Engine. Managed
   * certificates are tied to the lifecycle of a DomainMapping and cannot be
   * updated or deleted via the AuthorizedCertificates API. If this certificate
   * is manually administered by the user, this field will be empty.@OutputOnly
   *
   * @param ManagedCertificate $managedCertificate
   */
  public function setManagedCertificate(ManagedCertificate $managedCertificate)
  {
    $this->managedCertificate = $managedCertificate;
  }
  /**
   * @return ManagedCertificate
   */
  public function getManagedCertificate()
  {
    return $this->managedCertificate;
  }
  /**
   * Output only. Full path to the AuthorizedCertificate resource in the API.
   * Example: apps/myapp/authorizedCertificates/12345.@OutputOnly
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The full paths to user visible Domain Mapping resources that
   * have this certificate mapped. Example:
   * apps/myapp/domainMappings/example.com.This may not represent the full list
   * of mapped domain mappings if the user does not have VIEWER permissions on
   * all of the applications that have this certificate mapped. See
   * domain_mappings_count for a complete count.Only returned by GET or LIST
   * requests when specifically requested by the view=FULL_CERTIFICATE
   * option.@OutputOnly
   *
   * @param string[] $visibleDomainMappings
   */
  public function setVisibleDomainMappings($visibleDomainMappings)
  {
    $this->visibleDomainMappings = $visibleDomainMappings;
  }
  /**
   * @return string[]
   */
  public function getVisibleDomainMappings()
  {
    return $this->visibleDomainMappings;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AuthorizedCertificate::class, 'Google_Service_Appengine_AuthorizedCertificate');
