<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class SubscriptionDeferralInfo extends \Google\Model
{
  /**
   * The desired next expiry time to assign to the subscription, in milliseconds
   * since the Epoch. The given time must be later/greater than the current
   * expiry time for the subscription.
   *
   * @var string
   */
  public $desiredExpiryTimeMillis;
  /**
   * The expected expiry time for the subscription. If the current expiry time
   * for the subscription is not the value specified here, the deferral will not
   * occur.
   *
   * @var string
   */
  public $expectedExpiryTimeMillis;

  /**
   * The desired next expiry time to assign to the subscription, in milliseconds
   * since the Epoch. The given time must be later/greater than the current
   * expiry time for the subscription.
   *
   * @param string $desiredExpiryTimeMillis
   */
  public function setDesiredExpiryTimeMillis($desiredExpiryTimeMillis)
  {
    $this->desiredExpiryTimeMillis = $desiredExpiryTimeMillis;
  }
  /**
   * @return string
   */
  public function getDesiredExpiryTimeMillis()
  {
    return $this->desiredExpiryTimeMillis;
  }
  /**
   * The expected expiry time for the subscription. If the current expiry time
   * for the subscription is not the value specified here, the deferral will not
   * occur.
   *
   * @param string $expectedExpiryTimeMillis
   */
  public function setExpectedExpiryTimeMillis($expectedExpiryTimeMillis)
  {
    $this->expectedExpiryTimeMillis = $expectedExpiryTimeMillis;
  }
  /**
   * @return string
   */
  public function getExpectedExpiryTimeMillis()
  {
    return $this->expectedExpiryTimeMillis;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SubscriptionDeferralInfo::class, 'Google_Service_AndroidPublisher_SubscriptionDeferralInfo');
