import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:gap/gap.dart';
import 'package:hive_flutter/hive_flutter.dart';
import 'package:ready_grocery/components/ecommerce/confirmation_dialog.dart';
import 'package:ready_grocery/config/app_color.dart';
import 'package:ready_grocery/config/app_constants.dart';
import 'package:ready_grocery/config/app_text_style.dart';
import 'package:ready_grocery/config/theme.dart';
import 'package:ready_grocery/controllers/eCommerce/product/product_controller.dart';
import 'package:ready_grocery/generated/l10n.dart';
import 'package:ready_grocery/models/eCommerce/cart/hive_cart_model.dart';
import 'package:ready_grocery/models/eCommerce/product/product_details.dart';
import 'package:ready_grocery/routes.dart';
import 'package:ready_grocery/services/common/hive_service_provider.dart';
import 'package:ready_grocery/utils/context_less_navigation.dart';
import 'package:ready_grocery/utils/global_function.dart';
import 'package:ready_grocery/views/eCommerce/home/layouts/home_view_layout.dart';
import 'package:share_plus/share_plus.dart';

class ProductDescription extends ConsumerStatefulWidget {
  final ProductDetails productDetails;
  const ProductDescription({
    super.key,
    required this.productDetails,
  });

  @override
  ConsumerState<ProductDescription> createState() => _ProductDescriptionState();
}

class _ProductDescriptionState extends ConsumerState<ProductDescription> {
  bool isTextExpanded = false;
  bool isFavorite = true;
  @override
  void initState() {
    isFavorite = widget.productDetails.product.isFavorite;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return AnimatedContainer(
      duration: const Duration(milliseconds: 500),
      padding: EdgeInsets.symmetric(horizontal: 16.w, vertical: 8.h),
      width: double.infinity,
      color: GlobalFunction.getContainerColor(),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Text(
                  widget.productDetails.product.brand ?? 'N/A',
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: AppTextStyle(context).bodyTextSmall.copyWith(
                      color: colors(context).primaryColor,
                      fontWeight: FontWeight.w600,
                      fontSize: 12.sp),
                ),
              ),
              // InkWell(
              //   onTap: () {
              //     final websiteUrl =
              //         AppConstants.baseUrl.replaceAll("api", "products");
              //     Share.share(
              //         "check out my website $websiteUrl/${widget.productDetails.product.id}/details");
              //   },
              //   child: Card(
              //       child: Padding(
              //     padding: const EdgeInsets.all(6.0),
              //     child: Icon(Icons.share, color: colors(context).primaryColor),
              //   )),
              // ),
            ],
          ),
          Gap(8.h),
          Text(
            widget.productDetails.product.name,
            maxLines: 2,
            overflow: TextOverflow.ellipsis,
            style: AppTextStyle(context)
                .bodyText
                .copyWith(fontWeight: FontWeight.w600, fontSize: 16.sp),
          ),
          Gap(8.h),
          AnimatedSize(
            duration: const Duration(milliseconds: 500),
            child: isTextExpanded
                ? Text(
                    widget.productDetails.product.shortDescription,
                    style: AppTextStyle(context).bodyTextSmall.copyWith(
                          fontSize: 12.sp,
                          fontWeight: FontWeight.w400,
                        ),
                  )
                : Text(
                    widget.productDetails.product.shortDescription,
                    style: AppTextStyle(context)
                        .bodyTextSmall
                        .copyWith(fontSize: 13.sp, fontWeight: FontWeight.w400),
                    maxLines: 3,
                    overflow: TextOverflow.ellipsis,
                  ),
          ),
          Gap(2.h),
          GestureDetector(
            onTap: () {
              setState(() {
                isTextExpanded = !isTextExpanded;
              });
            },
            child: Text(
              isTextExpanded ? S.of(context).readLess : S.of(context).readMore,
              style: AppTextStyle(context).bodyTextSmall.copyWith(
                  color: colors(context).primaryColor,
                  decoration: TextDecoration.underline,
                  decorationColor: colors(context).primaryColor,
                  fontSize: 12.sp,
                  fontWeight: FontWeight.w400),
            ),
          ),
          Gap(8.h),
          _buildReviewAndSoldCount(context: context),
          Gap(12.h),
          _buildPriceAndAddToCart(context: context),
          Gap(18.h),
          //TODO: remove by habib-------->> check the real usage ok?
          // widget.productDetails.product.runningFlashSale != null
          //     ? DealOfTheDayWidget(
          //         showViewMore: false,
          //       )
          //     : const SizedBox(),
        ],
      ),
    );
  }

  Widget _buildReviewAndSoldCount({required BuildContext context}) {
    bool isDark =
        Theme.of(context).scaffoldBackgroundColor == EcommerceAppColor.black;
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Expanded(
          child: Row(
            children: [
              Icon(
                Icons.star_rounded,
                size: 16.sp,
                color: EcommerceAppColor.carrotOrange,
              ),
              Flexible(
                child: Text(
                  widget.productDetails.product.rating.toString(),
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: AppTextStyle(context).bodyText.copyWith(
                        fontSize: 14.sp,
                        fontWeight: FontWeight.w600,
                      ),
                ),
              ),
              Gap(5.w),
              Flexible(
                child: Text(
                  '(${widget.productDetails.product.totalReviews})',
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: AppTextStyle(context).bodyText.copyWith(
                      fontSize: 14.sp,
                      fontWeight: FontWeight.w400,
                      color: colors(context).bodyTextSmallColor),
                ),
              ),
              Gap(8.w),
              CircleAvatar(
                  radius: 3.r,
                  backgroundColor:
                      EcommerceAppColor.lightGray.withValues(alpha: 0.5)),
              Gap(8.w),
              SvgPicture.asset("assets/svg/box-check.svg"),
              Gap(4.w),
              Flexible(
                child: Text(
                  widget.productDetails.product.totalSold,
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: AppTextStyle(context).bodyText.copyWith(
                        fontSize: 14.sp,
                        fontWeight: FontWeight.w600,
                        // color: colors(context).bodyTextSmallColor,
                      ),
                ),
              ),
              Flexible(
                child: Text(
                  ' Sold',
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: AppTextStyle(context).bodyText.copyWith(
                        fontSize: 14.sp,
                        fontWeight: FontWeight.w400,
                        color: colors(context).bodyTextSmallColor,
                      ),
                ),
              ),
            ],
          ),
        ),
        GestureDetector(
          onTap: () {
            final websiteUrl =
                AppConstants.baseUrl.replaceAll("api", "products");
            Share.share(
                "check out my website $websiteUrl/${widget.productDetails.product.id}/details");
          },
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 6.w, vertical: 4.h),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4.r),
              color: isDark
                  ? EcommerceAppColor.gray.withValues(alpha: .3)
                  : EcommerceAppColor.lightBg,
            ),
            child: Row(
              children: [
                SvgPicture.asset(
                  "assets/svg/share2.svg",
                ),
                Gap(8.w),
                Text(
                  "Share",
                  style: AppTextStyle(context).bodyText.copyWith(
                        color: colors(context).primaryColor,
                      ),
                )
              ],
            ),
          ),
        )
      ],
    );
  }

  Widget _buildPriceAndAddToCart({required BuildContext context}) {
    bool isDark =
        Theme.of(context).scaffoldBackgroundColor == EcommerceAppColor.black;
    return ValueListenableBuilder<Box<HiveCartModel>>(
        valueListenable:
            Hive.box<HiveCartModel>(AppConstants.cartModelBox).listenable(),
        builder: (context, cartBox, _) {
          // bool inCart = false;
          // late int productQuantity;
          // int cartIndex = -1;
          final cartItems = cartBox.values.toList();
          for (int i = 0; i < cartItems.length; i++) {
            final cartProduct = cartItems[i];
            if (cartProduct.productId == widget.productDetails.product.id) {
              // inCart = true;
              // productQuantity = cartProduct.productsQTY;
              // cartIndex = i;
              break;
            }
          }

          return Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                  Visibility(
                    visible: widget.productDetails.product.discountPrice > 0,
                    child: Text(
                      GlobalFunction.price(
                        ref: ref,
                        price: widget.productDetails.product.price.toString(),
                      ),
                      style: AppTextStyle(context).bodyText.copyWith(
                            fontSize: 18.sp,
                            fontWeight: FontWeight.w400,
                            color: EcommerceAppColor.lightGray,
                            decoration: TextDecoration.lineThrough,
                            decorationColor: EcommerceAppColor.lightGray,
                          ),
                    ),
                  ),
                  Gap(8.w),
                  if (widget.productDetails.product.discountPrice > 0) ...[
                    Text(
                      GlobalFunction.price(
                        ref: ref,
                        price: (widget.productDetails.product.discountPrice +
                                ref.watch(selectedColorPriceProvider) +
                                ref.watch(selectedSizePriceProvider))
                            .toString(),
                      ),
                      style: AppTextStyle(context).bodyText.copyWith(
                          fontWeight: FontWeight.w700, fontSize: 24.sp),
                    ),
                  ] else ...[
                    Text(
                      GlobalFunction.price(
                        ref: ref,
                        price: (widget.productDetails.product.price +
                                ref.watch(selectedColorPriceProvider) +
                                ref.watch(selectedSizePriceProvider))
                            .toString(),
                      ),
                      style: AppTextStyle(context).bodyText.copyWith(
                          fontWeight: FontWeight.w700, fontSize: 24.sp),
                    ),
                  ],
                  // Gap(5.w),

                  Gap(16.w),
                  Visibility(
                    visible: widget.productDetails.product.discountPrice > 0,
                    child: Container(
                      padding:
                          EdgeInsets.symmetric(horizontal: 5.w, vertical: 5.h),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(14.r),
                        color: colors(context).errorColor,
                      ),
                      child: Center(
                        child: Text(
                          '-${widget.productDetails.product.discountPercentage} %',
                          maxLines: 1,
                          overflow: TextOverflow.ellipsis,
                          style: AppTextStyle(context).bodyTextSmall.copyWith(
                                color: colors(context).light,
                                fontSize: 12.sp,
                                fontWeight: FontWeight.w400,
                              ),
                        ),
                      ),
                    ),
                  )
                ],
              ),
              Container(
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  color: isDark
                      ? EcommerceAppColor.gray.withValues(alpha: .3)
                      : EcommerceAppColor.lightBg,
                ),
                child: AnimatedSize(
                  duration: const Duration(milliseconds: 250),
                  child: IconButton(
                    padding: EdgeInsets.zero,
                    visualDensity: VisualDensity.compact,
                    onPressed: () {
                      if (ref.read(hiveServiceProvider).userIsLoggedIn()) {
                        setState(() {
                          isFavorite = !isFavorite;
                        });
                        ref
                            .read(productControllerProvider.notifier)
                            .favoriteProductAddRemove(
                              productId: widget.productDetails.product.id,
                            );
                      } else {
                        showDialog(
                            context: context,
                            builder: (_) => ConfirmationDialog(
                                  title:
                                      'You are unable to favorite products without login!',
                                  confirmButtonText: 'Login',
                                  onPressed: () {
                                    context.nav.pushNamedAndRemoveUntil(
                                        Routes.login, (route) => false);
                                  },
                                ));
                      }
                    },
                    icon: isFavorite
                        ? Icon(
                            Icons.favorite,
                            size: 30.sp,
                            color: colors(context).errorColor,
                          )
                        : SvgPicture.asset(
                            "assets/svg/heart.svg",
                            color:
                                isDark ? Colors.white : EcommerceAppColor.black,
                          ),
                  ),
                ),
              ),

              // if (inCart) ...[
              //   IncrementDecrementButton(
              //     productQuantity: productQuantity,
              //     increment: () {
              //       ref.read(cartController.notifier).incrementProductQuantity(
              //             productId: widget.productDetails.product.id,
              //             cartBox: cartBox,
              //             index: cartIndex,
              //           );
              //     },
              //     decrement: () {
              //       ref.read(cartController.notifier).decrementProductQuantity(
              //             productId: widget.productDetails.product.id,
              //             cartBox: cartBox,
              //             index: cartIndex,
              //           );
              //     },
              //   )
              // ] else ...{
              //   IncrementButton(
              //     onTap: () async {
              //       HiveCartModel cartItem = HiveCartModel(
              //         shopId: widget.productDetails.product.shop.id,
              //         shopLogo: widget.productDetails.product.shop.logo,
              //         deliveryCharge:
              //             widget.productDetails.product.shop.deliveryCharge,
              //         shopName: widget.productDetails.product.shop.name,
              //         review: 4.7,
              //         productId: widget.productDetails.product.id,
              //         productLogo: widget
              //             .productDetails.product.thumbnails.first.thumbnail,
              //         title: widget.productDetails.product.name,
              //         price: GlobalFunction.getPrice(
              //           currentPrice: widget.productDetails.product.price,
              //           discountPrice:
              //               widget.productDetails.product.discountPrice,
              //         ),
              //         currentPrice: widget.productDetails.product.price,
              //         discountPrice:
              //             widget.productDetails.product.discountPrice,
              //         color: widget.productDetails.product.colors.isNotEmpty &&
              //                 ref.read(selectedProductColorIndex) != null
              //             ? widget.productDetails.product
              //                 .colors[ref.read(selectedProductColorIndex)!].name
              //                 .toLowerCase()
              //             : '',
              //         productsQTY: 1,
              //         size: '',
              //         unit: '',
              //       );
              //       await cartBox.add(cartItem);
              //     },
              //   )
              // },
            ],
          );
        });
  }
}
